# ConnectWise Sync Server

PHP API for saving and restoring extension data so users can sync across devices (e.g. after formatting or reinstalling).

## Endpoints

- **POST** `/api/auth.php` – Register or login (JSON: `action`, `email`, `password`, optional `full_name` for register). Returns `token` and `email`.
- **POST** `/api/save.php` – Save sync payload (header: `Authorization: Bearer <token>`).
- **GET** `/api/load.php` – Load sync payload (header: `Authorization: Bearer <token>`).

## Storage: MySQL (recommended)

All details (users, tokens, sync data) are stored in MySQL when configured.

### 1. Create database and user (cPanel)

In cPanel → **MySQL® Databases**:

1. Create a database, e.g. `frndcntr5dfapps_connectwise`.
2. Create a user and set a strong password.
3. Add the user to the database with **ALL PRIVILEGES**.

### 2. Run the schema

In **phpMyAdmin** (or MySQL CLI):

1. Select the database you created.
2. Open the **SQL** tab.
3. Paste and run the contents of `schema.sql`:

```sql
-- From server/schema.sql
CREATE TABLE IF NOT EXISTS `users` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `email` VARCHAR(255) NOT NULL,
  `password_hash` VARCHAR(255) NOT NULL,
  `full_name` VARCHAR(255) DEFAULT NULL,
  `created_at` INT UNSIGNED NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `tokens` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` INT UNSIGNED NOT NULL,
  `token` VARCHAR(64) NOT NULL,
  `expires_at` INT UNSIGNED NOT NULL,
  `created_at` INT UNSIGNED NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `token` (`token`),
  KEY `user_id` (`user_id`),
  KEY `expires_at` (`expires_at`),
  CONSTRAINT `tokens_user_fk` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `sync_data` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` INT UNSIGNED NOT NULL,
  `payload` LONGTEXT NOT NULL,
  `synced_at` INT UNSIGNED NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`),
  CONSTRAINT `sync_data_user_fk` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
```

### 3. Configure `config.php`

Edit `server/config.php` and set:

```php
define('USE_MYSQL', true);
define('DB_HOST', 'localhost');
define('DB_NAME', 'frndcntr5dfapps_connectwise');  // your database name
define('DB_USER', 'frndcntr5dfapps_connectwise');   // your MySQL username
define('DB_PASS', 'your_actual_password');      // your MySQL password (from cPanel MySQL user)
```

Use the database name, username, and password from cPanel (often with a prefix like `frndcntr5dfapps_`).

### 4. Deploy files

Upload to your server (e.g. **https://galileo.core-dns.net** – API and DB both on this cPanel host).

**Exact layout for cPanel `public_html` (fixes 404 on /api/auth.php):**

```
public_html/
├── config.php      ← from server/config.php
├── db.php          ← from server/db.php
├── schema.sql      ← run once in phpMyAdmin
└── api/
    ├── auth.php    ← from server/api/auth.php  (required for login)
    ├── save.php    ← from server/api/save.php
    └── load.php    ← from server/api/load.php
```

- If you get **404** on `galileo.core-dns.net/api/auth.php`, the `api` folder must contain **auth.php**, **save.php**, and **load.php** (upload or copy them into `public_html/api/`).
- `config.php` and `db.php` stay in `public_html` (parent of `api/`).

PHP 7.0+ with PDO MySQL is required.

## What is stored in MySQL

| Table | Purpose |
|-------|---------|
| **users** | One row per account: `email`, `password_hash`, optional `full_name`, `created_at`. |
| **tokens** | One row per login session: `user_id`, `token`, `expires_at`. Used to validate Bearer token. |
| **sync_config** | Configuration: `friend_request`, `messaging`, `scheduling`, `safety`, `settings` (JSON), `settings_initialized`. |
| **sync_segments** | Message segments (templates): `segment_id`, `title`, `message`, `sort_order`. |
| **sync_groups** | Message groups: `group_id`, `title`, `items` (JSON), `sort_order`. |
| **sync_automation_state** | Automation state and counters: `status`, `friend_requests_sent`, `messages_sent`, `session_*`, `errors`, `last_reset_date`, `session_start_time`. |
| **sync_activity_log** | Activity log entries: `timestamp`, `type`, `message`, `data` (JSON). |
| **sync_pending_friend_requests** | Pending friend requests with message tracking: `url`, `name`, `profile_id`, `sent_at`, `message_sent`, `stored_message`, etc. |
| **sync_position_resume** | Position/resume data: `last_search_position`, `last_search_url`. |
| **sync_pending_message_retry** | Pending message retry queue: `profile_id`, `profile_name`, `trigger`, `stored_message`, `attempts`, `last_attempt`. |
| **sync_tracking_sets** | Tracking sets (duplicate prevention): `set_key` (e.g. acceptedNotificationsMessageSent, incomingRequestsTracked), `set_value` (JSON array). |
| **sync_misc** | Misc key-value: `lastPendingRetryRunAt`, `lastMessageSentTo`, migration flags, etc. |
| **sync_data** | Full payload backup (one row per user): used by Load to restore the extension. |

On **Save**, the API writes the incoming payload into all of the above tables and into `sync_data`. On **Load**, the API returns the full payload from `sync_data` so the extension gets everything back. The other tables let you query or report on segments, groups, activity, pending requests, and state in SQL.

## File-based fallback

If you do **not** use MySQL, set in `config.php`:

```php
define('USE_MYSQL', false);
```

Then the server uses the `data/` directory (users in `data/users.json`, tokens in `data/tokens/`, sync in `data/sync/`). Ensure the web server can create and write to `data/`.
