<?php
/**
 * ConnectWise Sync – MySQL PDO connection (DB on galileo.core-dns.net cPanel).
 * Used when config defines DB_* and USE_MYSQL = true.
 */
if (!defined('USE_MYSQL') || !USE_MYSQL) {
  return;
}

$friender_pdo = null;

function friender_db(): PDO {
  global $friender_pdo;
  if ($friender_pdo !== null) {
    return $friender_pdo;
  }
  $dsn = 'mysql:host=' . DB_HOST . ';port=' . (defined('DB_PORT') ? DB_PORT : '3306') . ';dbname=' . DB_NAME . ';charset=utf8mb4';
  $friender_pdo = new PDO($dsn, DB_USER, DB_PASS, [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
  ]);
  return $friender_pdo;
}

/**
 * Resolve Bearer token to user id (integer). Returns null if invalid or expired.
 */
function friender_resolve_token(string $token): ?int {
  if (!strlen($token)) return null;
  try {
    $pdo = friender_db();
    $stmt = $pdo->prepare('SELECT user_id FROM tokens WHERE token = ? AND expires_at > ?');
    $stmt->execute([$token, time()]);
    $row = $stmt->fetch();
    return $row ? (int) $row['user_id'] : null;
  } catch (Throwable $e) {
    return null;
  }
}
